<?php
declare(strict_types=1);

function auth_boot(): void {
  $cfg = require __DIR__ . '/../config/config.php';
  date_default_timezone_set($cfg['app']['timezone']);
  session_name($cfg['app']['session_name']);
  session_start();
}

function require_login(): void {
  if (empty($_SESSION['uid'])) {
    header('Location: login.php');
    exit;
  }
}

function current_user_id(): ?int {
  return isset($_SESSION['uid']) ? (int)$_SESSION['uid'] : null;
}

function current_user_role(): string {
  return $_SESSION['role'] ?? 'staff';
}
