<?php
declare(strict_types=1);

function json_input(): array {
  $raw = file_get_contents('php://input');
  $data = json_decode($raw ?: '[]', true);
  return is_array($data) ? $data : [];
}

function json_out(array $payload, int $code = 200): void {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($payload, JSON_UNESCAPED_UNICODE);
  exit;
}

function today_date(): string {
  return date('Y-m-d');
}

function normalize_name(string $s): string {
  $s = mb_strtolower(trim($s));
  $s = preg_replace('/\s+/', ' ', $s);
  return $s ?: '';
}
