<?php
declare(strict_types=1);

require __DIR__ . '/../lib/db.php';
require __DIR__ . '/../lib/auth.php';
auth_boot();
require_login();

$products = db()->query("SELECT * FROM products WHERE active=1 ORDER BY category, name")->fetchAll();
$tx = db()->query("SELECT t.*, p.name AS product_name
                   FROM transactions t
                   LEFT JOIN products p ON p.id=t.product_id
                   ORDER BY t.id DESC LIMIT 25")->fetchAll();
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="assets/styles.css">
  <title>Admin – Cafona Libraire</title>
</head>
<body class="wrap">
  <header class="topbar">
    <div>
      <h1>Admin</h1>
      <div class="muted">Produits • Stock • Dernières opérations</div>
    </div>
    <nav class="nav">
      <a href="index.php">Chat</a>
      <a href="logout.php">Quitter</a>
    </nav>
  </header>

  <div class="grid">
    <section class="card">
      <h2>Ajouter / Mettre à jour un produit</h2>
      <form id="prodForm">
        <label>Nom</label>
        <input name="name" required>
        <label>Catégorie</label>
        <input name="category" placeholder="Livre, Cahier, Fourniture…">
        <label>Prix de vente (FCFA)</label>
        <input name="sell_price" type="number" step="1" required>
        <label>Stock</label>
        <input name="stock_qty" type="number" step="1" required>
        <label>Seuil d'alerte</label>
        <input name="reorder_level" type="number" step="1" value="0" required>
        <button type="submit">Enregistrer</button>
      </form>
      <div id="prodMsg" class="muted" style="margin-top:8px;"></div>
    </section>

    <section class="card">
      <h2>Produits</h2>
      <div class="tablewrap">
        <table>
          <thead><tr><th>Nom</th><th>Cat.</th><th>Prix</th><th>Stock</th><th>Seuil</th></tr></thead>
          <tbody>
          <?php foreach ($products as $p): ?>
            <tr>
              <td><?= htmlspecialchars($p['name']) ?></td>
              <td><?= htmlspecialchars($p['category']) ?></td>
              <td><?= (int)$p['sell_price'] ?></td>
              <td><?= (int)$p['stock_qty'] ?></td>
              <td><?= (int)$p['reorder_level'] ?></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </section>

    <section class="card" style="grid-column: 1 / -1;">
      <h2>25 dernières opérations</h2>
      <div class="tablewrap">
        <table>
          <thead><tr><th>Date</th><th>Type</th><th>Produit</th><th>Qté</th><th>Montant</th><th>Note</th></tr></thead>
          <tbody>
          <?php foreach ($tx as $t): ?>
            <tr>
              <td><?= htmlspecialchars($t['created_at']) ?></td>
              <td><?= htmlspecialchars($t['type']) ?></td>
              <td><?= htmlspecialchars($t['product_name'] ?? '-') ?></td>
              <td><?= htmlspecialchars((string)($t['quantity'] ?? '-')) ?></td>
              <td><?= htmlspecialchars((string)$t['amount']) ?></td>
              <td><?= htmlspecialchars($t['note'] ?? '') ?></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </section>
  </div>

<script>
document.getElementById('prodForm').addEventListener('submit', async (e) => {
  e.preventDefault();
  const fd = new FormData(e.target);
  const payload = Object.fromEntries(fd.entries());
  const res = await fetch('../api/admin_products.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify(payload)
  });
  const data = await res.json();
  document.getElementById('prodMsg').textContent = data.ok ? '✅ Enregistré.' : ('❌ ' + data.error);
  if (data.ok) setTimeout(()=>location.reload(), 600);
});
</script>
</body>
</html>
