const messages = document.getElementById('messages');
const form = document.getElementById('chatForm');
const input = document.getElementById('text');

function addMsg(text, who) {
  const div = document.createElement('div');
  div.className = `msg ${who}`;
  div.textContent = text;
  messages.appendChild(div);
  div.scrollIntoView({behavior:'smooth', block:'end'});
}

document.querySelectorAll('.chip').forEach(b => {
  b.addEventListener('click', () => {
    input.value = b.dataset.msg;
    input.focus();
  });
});

form.addEventListener('submit', async (e) => {
  e.preventDefault();
  const text = (input.value || '').trim();
  if (!text) return;
  addMsg(text, 'me');
  input.value = '';
  try {
    const res = await fetch('../api/chat.php', {
      method: 'POST',
      headers: {'Content-Type':'application/json'},
      body: JSON.stringify({message: text})
    });
    const data = await res.json();
    if (data.ok) addMsg(data.reply, 'bot');
    else addMsg('Erreur: ' + data.error, 'bot');
  } catch (err) {
    addMsg('Erreur réseau.', 'bot');
  }
});
