<?php
declare(strict_types=1);

require __DIR__ . '/../lib/db.php';
require __DIR__ . '/../lib/auth.php';
auth_boot();
require_login();

$products = db()->query("SELECT * FROM products WHERE active=1 ORDER BY category, name")->fetchAll();
$tx = db()->query("SELECT t.*, p.name AS product_name
                   FROM transactions t
                   LEFT JOIN products p ON p.id=t.product_id
                   ORDER BY t.id DESC LIMIT 25")->fetchAll();
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="assets/styles.css">
  <title>Administration – Cafona Libraire</title>
</head>
<body>
  <div class="container app">
    <aside class="sidebar">
      <div class="brand">
        <img src="assets/img/logo.svg" alt="Cafona">
        <div>
          <div class="title">Cafona Libraire</div>
          <div class="muted small">Gestion produits & opérations</div>
        </div>
      </div>

      <nav class="nav" aria-label="Navigation">
        <a href="index.php"><span>Assistant</span><span class="muted">↩</span></a>
        <a class="active" href="admin.php"><span>Administration</span><span class="muted">↩</span></a>
        <a href="logout.php"><span>Déconnexion</span><span class="muted">⎋</span></a>
      </nav>

      <div class="card" style="margin-top:14px;">
        <h3>Conseil</h3>
        <div class="muted">Après une mise à jour, tu peux écrire dans l’assistant :</div>
        <div class="chips">
          <button class="chip" type="button" data-msg="Montre le stock bas">Stock bas</button>
          <button class="chip" type="button" data-msg="Fais le résumé du jour">Résumé</button>
        </div>
        <div class="footer-note">Astuce: active le thème clair pour la journée.</div>
      </div>
    </aside>

    <main>
      <header class="topbar">
        <div>
          <h1>Administration</h1>
          <div class="muted">Ajouter des articles, ajuster le stock, contrôler les dernières opérations.</div>
        </div>
        <div class="top-actions">
          <button class="btn ghost" type="button" data-action="theme">Thème</button>
          <a class="btn" href="index.php">Retour</a>
        </div>
      </header>

      <div class="grid">
        <section class="card">
          <h2>Ajouter / Mettre à jour un produit</h2>
          <form id="prodForm">
            <label>Nom</label>
            <input name="name" required>
            <label>Catégorie</label>
            <input name="category" placeholder="Livre, Cahier, Fourniture…">
            <label>Prix de vente (FCFA)</label>
            <input name="sell_price" type="number" step="1" required>
            <label>Stock</label>
            <input name="stock_qty" type="number" step="1" required>
            <label>Seuil d'alerte</label>
            <input name="reorder_level" type="number" step="1" value="0" required>
            <button class="btn primary" type="submit">Enregistrer</button>
          </form>
          <div id="prodMsg" class="muted" style="margin-top:8px;"></div>
        </section>

        <section class="card">
          <h2>Produits actifs</h2>
          <div class="tablewrap">
            <table>
              <thead><tr><th>Nom</th><th>Cat.</th><th>Prix</th><th>Stock</th><th>Seuil</th></tr></thead>
              <tbody>
              <?php foreach ($products as $p): ?>
                <tr>
                  <td><?= htmlspecialchars($p['name']) ?></td>
                  <td><?= htmlspecialchars($p['category']) ?></td>
                  <td><?= (int)$p['sell_price'] ?></td>
                  <td><?= (int)$p['stock_qty'] ?></td>
                  <td><?= (int)$p['reorder_level'] ?></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </section>

        <section class="card" style="grid-column: 1 / -1;">
          <h2>25 dernières opérations</h2>
          <div class="tablewrap">
            <table>
              <thead><tr><th>Date</th><th>Type</th><th>Produit</th><th>Qté</th><th>Montant</th><th>Note</th></tr></thead>
              <tbody>
              <?php foreach ($tx as $t): ?>
                <tr>
                  <td><?= htmlspecialchars($t['created_at']) ?></td>
                  <td><?= htmlspecialchars($t['type']) ?></td>
                  <td><?= htmlspecialchars($t['product_name'] ?? '-') ?></td>
                  <td><?= htmlspecialchars((string)($t['quantity'] ?? '-')) ?></td>
                  <td><?= htmlspecialchars((string)$t['amount']) ?></td>
                  <td><?= htmlspecialchars($t['note'] ?? '') ?></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </section>
      </div>
    </main>
  </div>

  <script src="assets/app.js"></script>
  <script>
  document.getElementById('prodForm').addEventListener('submit', async (e) => {
    e.preventDefault();
    const fd = new FormData(e.target);
    const payload = Object.fromEntries(fd.entries());
    const res = await fetch('../api/admin_products.php', {
      method: 'POST',
      headers: {'Content-Type': 'application/json'},
      body: JSON.stringify(payload)
    });
    const data = await res.json();
    document.getElementById('prodMsg').textContent = data.ok ? '✅ Enregistré.' : ('❌ ' + (data.error || 'Erreur'));
    if (data.ok) setTimeout(()=>location.reload(), 600);
  });
  </script>
</body>
</html>
