<?php
declare(strict_types=1);

require __DIR__ . '/../lib/db.php';
require __DIR__ . '/../lib/auth.php';
auth_boot();

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim($_POST['username'] ?? '');
  $p = $_POST['password'] ?? '';

  $stmt = db()->prepare("SELECT id, username, pass_hash, role FROM users WHERE username = ?");
  $stmt->execute([$u]);
  $user = $stmt->fetch();

  if ($user && password_verify($p, $user['pass_hash'])) {
    $_SESSION['uid'] = (int)$user['id'];
    $_SESSION['role'] = $user['role'];
    header('Location: index.php');
    exit;
  }
  $error = 'Identifiants invalides.';
}
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="assets/styles.css">
  <title>Cafona Libraire – Connexion</title>
</head>
<body class="auth-shell">
  <div class="auth-card">
    <div class="hero">
      <div class="row">
        <img src="assets/img/logo.svg" alt="Cafona">
        <div>
          <h1>Bienvenue sur Cafona Libraire Intelligent</h1>
          <div class="muted">Saisie rapide en langage naturel pour gérer ventes, dépenses et stock.</div>
        </div>
      </div>
      <ul>
        <li>Écris: <b>“Vendu 3 cahiers à 500 FCFA”</b></li>
        <li>Écris: <b>“Dépense 2000 transport”</b></li>
        <li>Écris: <b>“Fais le résumé du jour”</b></li>
      </ul>
      <div style="margin-top:12px;display:flex;gap:10px;flex-wrap:wrap;">
        <button class="btn ghost" type="button" data-action="theme">Thème</button>
        <span class="badge"><span style="display:inline-flex;width:10px;height:10px;border-radius:999px;background:var(--primary)"></span> Interface optimisée</span>
      </div>
    </div>

    <div class="card">
      <h2>Connexion</h2>
      <p class="muted">Compte initial: <b>owner</b> / <b>ChangeMe123!</b></p>
      <?php if ($error): ?><div class="alert"><?= htmlspecialchars($error) ?></div><?php endif; ?>

      <form method="post" autocomplete="on">
        <label>Utilisateur</label>
        <input name="username" required>
        <label>Mot de passe</label>
        <input type="password" name="password" required>
        <button class="btn primary" type="submit">Se connecter</button>
      </form>

      <div class="footer-note">Conseil: change le mot de passe du compte <b>owner</b> après la première connexion.</div>
    </div>
  </div>

  <script src="assets/app.js"></script>
</body>
</html>
